//
//  TWMenuTableViewCell.m
//  Twitch
//
//  Created by Auston Stewart on 10/30/13.
//  Copyright (c) 2013 Justin.tv. All rights reserved.
//

#import "TWMenuTableViewCell.h"
#import "UIFont+Twitch.h"

NSString *const TWMenuTableViewCellReuseIdentifier = @"TWMenuTableViewCellReuseIdentifier";

@implementation TWMenuTableViewCell

+ (NSString *)reuseIdentifier
{
	return TWMenuTableViewCellReuseIdentifier;
}

- (void)commonInitialization
{
	[super commonInitialization];
	
	self.backgroundColor = [UIColor twitchNavigationMenuCellBackgroundColorNormal];
	self.selectedBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0.f, 0.f, self.frame.size.width, self.frame.size.height)];
	self.selectedBackgroundView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
	
	self.textLabel.font = [UIFont twitchCellTextFont];
	self.textLabel.textColor = [UIColor twitchNavigationMenuCellTextColorNormal];
	self.detailTextLabel.font = [UIFont twitchCellDetailTextFont];
	self.detailTextLabel.textColor = [UIColor twitchNavigationMenuCellDetailTextColorNormal];
	
	self.bottomSeparatorColor = [UIColor twitchNavigationMenuCellSeparatorColorNormal];
	_adjustsTextColor = YES;
	_adjustsImageTint = NO;
	_adjustsAccessoryTint = YES;
	_showSelection = YES;
	[self updateElementTints];
}

- (UIControlState)controlState
{
	return self.selected ? UIControlStateSelected : (self.highlighted ? UIControlStateHighlighted : UIControlStateNormal);
}

- (void)setSelected:(BOOL)selected
{
	[super setSelected:selected];
	[self updateElementTints];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated
{
	// FIXME: If requested, actually animate the selection state
	[super setSelected:selected animated:animated];
	[self updateElementTints];
}

- (void)updateElementTints
{
	UIColor *imageTint = nil;
	UIColor *accessoryTint = nil;
	UIControlState controlState = [self controlState];
	
	if (controlState == UIControlStateNormal) {
		imageTint = [UIColor twitchNavigationMenuIconColorNormal];
		accessoryTint = [UIColor twitchNavigationMenuDisclosureIndicatorColorNormal];
		// The highlighted background is set through selectedBackgroundView
		self.selectedBackgroundView.backgroundColor = [UIColor twitchNavigationMenuCellBackgroundColorPressed];
		// The highlighted text color is determined by UILabel's highlightedTextColor property
		self.textLabel.highlightedTextColor = [UIColor twitchNavigationMenuCellTextColorPressed];
		self.detailTextLabel.highlightedTextColor = [UIColor twitchNavigationMenuCellDetailTextColorPressed];
	}
	else if (controlState == UIControlStateHighlighted) {
		imageTint = [UIColor twitchNavigationMenuIconColorPressed];
		accessoryTint = [UIColor twitchNavigationMenuDisclosureIndicatorColorPressed];
		// The highlighted background is set through selectedBackgroundView
		self.selectedBackgroundView.backgroundColor = [UIColor twitchNavigationMenuCellBackgroundColorPressed];
		// The highlighted text color is determined by UILabel's highlightedTextColor property
		self.textLabel.highlightedTextColor = [UIColor twitchNavigationMenuCellTextColorPressed];
		self.detailTextLabel.highlightedTextColor = [UIColor twitchNavigationMenuCellDetailTextColorPressed];
		
	}
	else if (controlState == UIControlStateSelected && _showSelection) {
		imageTint = [UIColor twitchNavigationMenuIconColorSelected];
		accessoryTint = [UIColor twitchNavigationMenuDisclosureIndicatorColorSelected];
		
		self.selectedBackgroundView.backgroundColor = [UIColor twitchNavigationMenuCellBackgroundColorSelected];
		self.textLabel.highlightedTextColor = [UIColor twitchNavigationMenuCellTextColorSelected];
		self.detailTextLabel.highlightedTextColor = [UIColor twitchNavigationMenuCellTextColorSelected];
	}
	
	if (_adjustsImageTint && imageTint) {
		
		self.imageView.tintColor = imageTint;
	}
	if (_adjustsAccessoryTint && accessoryTint)
		self.accessoryTintColor = accessoryTint;
}

- (void)setHighlighted:(BOOL)highlighted
{
	[super setHighlighted:highlighted];
	[self updateElementTints];
}

- (void)setHighlighted:(BOOL)highlighted animated:(BOOL)animated
{
	[super setHighlighted:highlighted animated:animated];
	[self updateElementTints];
}

- (void)setAdjustsImageTint:(BOOL)adjustsImageTint
{
	if (_adjustsImageTint != adjustsImageTint) {
		
		_adjustsImageTint = adjustsImageTint;
		if (_adjustsImageTint) {
			self.imageView.tintAdjustmentMode = UIViewTintAdjustmentModeNormal;
			[self updateElementTints];
		}
		else self.imageView.tintAdjustmentMode = UIViewTintAdjustmentModeAutomatic;
	}
}

- (void)setAdjustsAccessoryTint:(BOOL)adjustsAccessoryTint
{
	if (_adjustsAccessoryTint != adjustsAccessoryTint) {
		
		_adjustsAccessoryTint = adjustsAccessoryTint;
		if (_adjustsAccessoryTint) {
			
			[self updateElementTints];
		}
	}
}

@end
